import { nanoId } from 'src/utils/nanoId';

import { URL } from 'src/constants/urls';

import { oAuthToken } from 'src/entities/OAuthToken';
import { userConsumer } from 'src/entities/UserConsumer';
import { modal } from 'src/entities/Modal';
import { Errors } from 'src/types/errors';

const SEPARATOR = '-';
const ACCOUNT_LOGIN_PREFIX = `yndx${SEPARATOR}`;

const MAX_ACCOUNT_LOGIN_LENGTH = 30;
const LOGIN_POSTFIX_LENGTH = 9;
const RANDOM_STRING_LENGTH = LOGIN_POSTFIX_LENGTH - SEPARATOR.length;

export function getMaxLoginLength() {
    return MAX_ACCOUNT_LOGIN_LENGTH - ACCOUNT_LOGIN_PREFIX.length - LOGIN_POSTFIX_LENGTH;
}

function getCorrectLogin({ yandexTeamLogin }) {
    const postfix = `${SEPARATOR}${nanoId(RANDOM_STRING_LENGTH)}`;

    const maxLoginLength = getMaxLoginLength();

    const modifiedLogin = yandexTeamLogin.substring(0, maxLoginLength);

    return `${ACCOUNT_LOGIN_PREFIX}${modifiedLogin}${postfix}`;
}

export function getNewAccount({ onErrorCallback, onSuccessCallback, params }) {
    const { environment, customLogin, yandexTeamLogin = 'yawe', password } = params;

    const xhr = new XMLHttpRequest();
    const url = `${URL.CREATE_ACCOUNT}?env=${environment}&login=${getCorrectLogin({
        yandexTeamLogin: customLogin || yandexTeamLogin,
    })}&tus_consumer=${userConsumer.get()}&password=${password}`;

    xhr.open('POST', url);
    xhr.setRequestHeader('Authorization', `OAuth ${oAuthToken.get()}`);
    xhr.onreadystatechange = function(xhr) {
        if (xhr.target.readyState !== 4) {
            return;
        }

        let account;

        try {
            const result = JSON.parse(xhr.target.response) || {};
            account = result.account;
        } catch (error) {
            console.error(error);
        }

        if (!account) {
            onErrorCallback();

            modal.setData({
                type: 'error',
                message: Errors.CAN_NOT_GENERATE_ACCOUNT,
                retryButtonText: 'Попробовать еще раз',
                callback: () => getNewAccount({ onErrorCallback, onSuccessCallback, params }),
            });
            modal.show();

            return;
        }

        onSuccessCallback(xhr);
    };
    xhr.send();
}
