import { URL } from 'src/constants/urls';
import { logError, logInfo } from 'src/logger';

import { Header, RequestMethod } from './types';

export async function getYandexTeamLogin({ oAuthToken }) {
    const requestURL = `${URL.YANDEX_TEAM_INFO}?format=json`;
    logInfo({ message: 'data-provider:getYandexTeamLogin:start' });

    const headers = {
        [Header.AUTHORIZATION]: `OAuth ${oAuthToken}`,
    };

    const response = await fetch(requestURL, {
        headers,
        method: RequestMethod.GET,
    });

    const responseText = await response.text();

    try {
        const { login } = JSON.parse(responseText);

        logInfo({ message: 'data-provider:getYandexTeamLogin:success' });

        return login;
    } catch (error) {
        console.error('getYandexTeamLogin response: ', responseText);
        console.error('getYandexTeamLogin error: ', error);
        logError({ message: 'data-provider:getYandexTeamLogin:fail' });
    }
}
