import { URL } from 'src/constants/urls';
import { Header, RequestMethod } from 'src/dataProvider/types';

import { oAuthToken } from 'src/entities/OAuthToken';

export async function removeAccount(params) {
    const { uid, env, tus_consumer } = params;

    const requestURL = `${URL.REMOVE_ACCOUNT}?uid=${uid}&env=${env}&tus_consumer=${tus_consumer}`;

    const headers = {
        [Header.AUTHORIZATION]: `OAuth ${oAuthToken.get()}`,
    };

    const response = await fetch(requestURL, { headers, method: RequestMethod.GET });

    const responseText = await response.text();

    try {
        const { status, error } = JSON.parse(responseText);

        const isSuccess = status === 'ok';
        const isError = !isSuccess && error;

        return { isSuccess, isError, error };
    } catch (error) {
        console.error('removeAccount response: ', responseText);
        console.error('removeAccount error: ', error);
    }
}
