import { URL } from 'src/constants/urls';
import { Header, RequestMethod } from 'src/dataProvider/types';

import { oAuthToken } from 'src/entities/OAuthToken';
import { trackerTask } from 'src/entities/TrackerTask';
import {
    getUserSynchronizationText,
    parseUserSynchronizationText,
} from 'src/entities/SynchronizationData/helpers';
import {
    INITIAL_SYNCHRONIZATION_DATA,
    SYNCHRONIZATION_DATA_MARKER,
} from 'src/entities/SynchronizationData/types';
import { logError, logInfo } from 'src/logger';

export async function createNewSynchronizationData() {
    logInfo({ message: 'data-provider:createNewSynchronizationData:start' });
    const requestURL = `${URL.TRACKER}/issues/${trackerTask.get()}/comments`;

    const headers = {
        [Header.AUTHORIZATION]: `OAuth ${oAuthToken.get()}`,
    };

    const body = JSON.stringify({
        text: getUserSynchronizationText(INITIAL_SYNCHRONIZATION_DATA),
    });

    const response = await fetch(requestURL, { body, headers, method: RequestMethod.POST });

    const responseText = await response.text();

    try {
        const responseData = JSON.parse(responseText);
        const { id: synchronizationDataId, text: synchronizationText } = responseData;

        const isSuccess = synchronizationText.includes(SYNCHRONIZATION_DATA_MARKER);
        const synchronizationData = parseUserSynchronizationText(synchronizationText);

        if (isSuccess) {
            logInfo({ message: 'data-provider:createNewSynchronizationData:success' });
        } else {
            logError({ message: 'data-provider:createNewSynchronizationData:fail' });
        }

        return {
            isSuccess,
            synchronizationData,
            synchronizationDataId,
        };
    } catch (error) {
        console.error('createNewSynchronizationData response: ', responseText);
        console.error('createNewSynchronizationData error: ', error);

        logError({ message: 'data-provider:createNewSynchronizationData:fail' });

        return {
            isSuccess: false,
            synchronizationData: '',
            synchronizationDataId: undefined,
        };
    }
}
