import { URL } from 'src/constants/urls';
import { Header, RequestMethod } from 'src/dataProvider/types';

import { oAuthToken } from 'src/entities/OAuthToken';
import { userConsumer } from 'src/entities/UserConsumer';
import { logError, logInfo } from 'src/logger';

import { trackerConfig } from './types';

export async function createTaskForUserConsumer() {
    logInfo({ message: 'data-provider:createTaskForUserConsumer:start' });
    const requestURL = `${URL.TRACKER}/issues`;

    const headers = {
        [Header.AUTHORIZATION]: `OAuth ${oAuthToken.get()}`,
    };

    const body = JSON.stringify({
        queue: trackerConfig.QUEUE,
        summary: userConsumer.get(),
        tags: trackerConfig.TAGS,
    });

    const response = await fetch(requestURL, { body, headers, method: RequestMethod.POST });

    const responseText = await response.text();

    try {
        const { key: taskKey = '' } = JSON.parse(responseText) || {};

        const isSuccess = taskKey.includes(trackerConfig.QUEUE);

        if (isSuccess) {
            logInfo({ message: 'data-provider:createTaskForUserConsumer:success' });
        } else {
            logError({ message: 'data-provider:createTaskForUserConsumer:fail' });
        }

        return { isSuccess, taskKey };
    } catch (error) {
        console.error('saveAccount response: ', responseText);
        console.error('saveAccount error: ', error);

        logError({ message: 'data-provider:createTaskForUserConsumer:fail' });

        return { isSuccess: false, taskKey: '' };
    }
}
