import { URL } from 'src/constants/urls';
import { Header, RequestMethod } from 'src/dataProvider/types';

import { oAuthToken } from 'src/entities/OAuthToken';
import { userConsumer } from 'src/entities/UserConsumer';
import { logError, logInfo } from 'src/logger';

import { trackerConfig } from './types';

export async function findTaskByUserConsumer() {
    const requestURL = `${URL.TRACKER}/issues`
        .concat('?filter=')
        .concat(`queue:${trackerConfig.QUEUE}`)
        .concat('&filter=')
        .concat(`summary:${userConsumer.get()}`)
        .concat('&filter=')
        .concat(`tags:${trackerConfig.TAGS.join()}`);
    logInfo({ message: 'data-provider:findTaskByUserConsumer:start' });

    const headers = {
        [Header.AUTHORIZATION]: `OAuth ${oAuthToken.get()}`,
    };

    const response = await fetch(requestURL, { headers, method: RequestMethod.GET });

    const responseText = await response.text();

    try {
        // Изначально считаем, что тикет может существовать
        // Если taskCanExist === true, то новый тикет создавать нельзя!
        let taskCanExist = true;
        // Ключ тикета формата YAWE-[NUMBER]
        let taskKey = '';

        const responseData = JSON.parse(responseText);

        // Если ручка успешно отработала и тикет не нашелся
        if (Array.isArray(responseData) && !responseData.length) {
            // То считаем, что тикета точно нет и можно попытаться создать его для пользователя
            taskCanExist = false;
        } else if (Array.isArray(responseData) && responseData.length === 1) {
            // Запрос можно считать действительно успешным если ручка вернула только один тикет
            taskKey = responseData[0].key;
        }

        // Удалось ли найти тикет пользователя
        const isSuccess = taskKey.includes(trackerConfig.QUEUE);

        if (isSuccess) {
            logInfo({ message: 'data-provider:findTaskByUserConsumer:success' });
        } else {
            logError({ message: 'data-provider:findTaskByUserConsumer:fail' });
        }

        return { taskCanExist, isSuccess, taskKey };
    } catch (error) {
        console.error('findTaskByUserConsumer response: ', responseText);
        console.error('findTaskByUserConsumer error: ', error);

        logError({ message: 'data-provider:findTaskByUserConsumer:fail' });

        return { taskCanExist: true, isSuccess: false, taskKey: '' };
    }
}
