import { URL } from 'src/constants/urls';
import { Header, RequestMethod } from 'src/dataProvider/types';

import { oAuthToken } from 'src/entities/OAuthToken';
import { trackerTask } from 'src/entities/TrackerTask';
import { getUserSynchronizationText } from 'src/entities/SynchronizationData/helpers';
import { synchronizationData } from 'src/entities/SynchronizationData';
import { synchronizationDataId } from 'src/entities/SynchronizationDataId';
import { SYNCHRONIZATION_DATA_MARKER } from 'src/entities/SynchronizationData/types';
import { modal } from 'src/entities/Modal';
import { Errors } from 'src/types/errors';
import { logError, logInfo } from 'src/logger';

export async function patchSynchronizationData() {
    const task = trackerTask.get();
    const commentId = synchronizationDataId.get();
    logInfo({ message: 'data-provider:patchSynchronizationData:start' });

    const requestURL = `${URL.TRACKER}/issues/${task}/comments/${commentId}`;

    const headers = {
        [Header.AUTHORIZATION]: `OAuth ${oAuthToken.get()}`,
    };

    const body = JSON.stringify({
        text: getUserSynchronizationText(synchronizationData.get()),
    });

    let response;
    let responseText;
    try {
        response = await fetch(requestURL, { body, headers, method: RequestMethod.PATCH });
        responseText = await response.text();
    } catch (error) {}

    try {
        const { text } = JSON.parse(responseText);

        const isSuccess = text.includes(SYNCHRONIZATION_DATA_MARKER);

        if (isSuccess) {
            logInfo({ message: 'data-provider:patchSynchronizationData:success' });
        }
        // Если что-то пошло не так, то показываем ошибку
        else {
            modal.setData({
                type: 'error',
                message: Errors.CAN_NOT_SYNC_USER_DATA,
            });
            modal.show();
            logError({ message: 'data-provider:patchSynchronizationData:fail' });
        }

        return { isSuccess };
    } catch (error) {
        // Аналогично если не получилось распарсить данные, то показываем ошибку
        modal.setData({
            type: 'error',
            message: Errors.CAN_NOT_SYNC_USER_DATA,
        });
        modal.show();
        logError({ message: 'data-provider:patchSynchronizationData:fail' });

        console.error('createNewSynchronizationData response: ', responseText);
        console.error('createNewSynchronizationData error: ', error);
    }
}
