import { synchronizationData as synchronizationDataEntity } from 'src/entities/SynchronizationData';
import { logInfo, logError } from 'src/logger';

/** Обновляет аккаунт */
export async function addToBookmarks() {
    const { uid, environment, name, date } = this._account;

    let synchronizationData = synchronizationDataEntity.get();

    if (!synchronizationData) {
        // Если в данный момент нет данных синхронизации, то пытаемся их зафетчить
        await synchronizationDataEntity.tryFetchSynchronizationData();
    }

    // Формируем запись об аккаунте
    const accountSynchronizationData = {
        [uid]: {
            uid,
            environment,
            name,
            date,
        },
    };

    // Делаем запись в данные синхронизации
    const { isSuccess } = await synchronizationDataEntity.update(accountSynchronizationData);

    if (isSuccess) {
        this._account.inBookmarks = true;
        logInfo({ message: 'add-to-bookmark:success' });
    } else {
        logError({ message: 'add-to-bookmark:fail' });
    }

    return this.get();
}
