import { synchronizationData as synchronizationDataEntity } from 'src/entities/SynchronizationData';
import { logInfo, logError } from 'src/logger';

export async function toggleBookmark() {
    const { uid, environment, inBookmarks, name, date } = this._account;
    logInfo({ message: 'toggle-bookmark:start' });

    let synchronizationData = synchronizationDataEntity.get();

    if (!synchronizationData) {
        // Если в данный момент нет данных синхронизации, то пытаемся их зафетчить
        await synchronizationDataEntity.tryFetchSynchronizationData();
    }

    if (inBookmarks) {
        // Если аккаунт уже в закладках, то убираем его из закладок
        const { isSuccess } = await synchronizationDataEntity.removeElement(uid);

        if (isSuccess) {
            // Если логика отработала успешно, то обновляем и локальное состояние приложения
            this._account.inBookmarks = !this._account.inBookmarks;
            logInfo({ message: 'toggle-bookmark:success' });
        } else {
            logError({ message: 'toggle-bookmark:fail' });
        }

        return this.get();
    }

    // Формируем запись об аккаунте
    const accountSynchronizationData = {
        [uid]: {
            uid,
            environment,
            name,
            date,
        },
    };

    // Делаем запись в данные синхронизации
    const { isSuccess } = await synchronizationDataEntity.update(accountSynchronizationData);

    if (isSuccess) {
        this._account.inBookmarks = !this._account.inBookmarks;
        logInfo({ message: 'toggle-bookmark:success' });
    } else {
        logError({ message: 'toggle-bookmark:fail' });
    }

    return this.get();
}
