import { Environment } from './types';

import { toggleBookmark } from './bookmark';
import { addToBookmarks } from './addToBookmarks';

/** Эта сущность используется в AccountsManager
 * Если вы хотите использовать ее отдельно,
 * то скорее всего вы что-то делаете неправильно */
export class Account {
    constructor(account) {
        this._account = account;

        this.toggleBookmark = toggleBookmark.bind(this);
        this.addToBookmarks = addToBookmarks.bind(this);
    }

    get() {
        return this._account;
    }

    isTest() {
        return this._account.environment === Environment.TEST;
    }

    isProd() {
        return this._account.environment === Environment.PROD;
    }

    inBookmarks() {
        return Boolean(this._account.inBookmarks);
    }
}
