import { nanoId } from 'src/utils/nanoId';

const RANDOM_PASSWORD_LENGTH = 8;
const MAX_PASSWORD_LENGTH = 12;

class AccountPassword {
    constructor() {
        this._accountPassword = nanoId(RANDOM_PASSWORD_LENGTH);
    }

    getMaxPasswordLength() {
        return MAX_PASSWORD_LENGTH;
    }

    get() {
        return this._accountPassword;
    }

    set(value) {
        this._accountPassword = value;
    }

    update() {
        this.set(nanoId(RANDOM_PASSWORD_LENGTH));
        return this.get();
    }
}

export const accountPassword = new AccountPassword();
