export function createFilter(filter) {
    /** params - переменный параметры фильтра */
    return function(accounts, params = {}) {
        if (!filter) {
            // Если нет фильтра, ничего не делаем
            return accounts;
        }

        return Object.values(accounts).reduce((result, account) => {
            if (!filter({ account, ...params })) {
                // Если аккаунт не прошел фильтрацию (фильтр вернул false), не добавляем его в результат
                return result;
            }

            const { uid } = account.get();

            result[uid] = account;
            return result;
        }, {});
    };
}
