import { production } from './production';
import { testing } from './testing';
import { bookmarks } from './bookmarks';

export const environmentFilters = [
    { name: 'Any', filter: null },
    { name: 'Testing', filter: testing },
    { name: 'Production', filter: production },
    { name: 'Bookmarks', filter: bookmarks },
];

export function getFilterIdByName(filterName) {
    return environmentFilters.findIndex(({ name }) => name === filterName) || 0;
}
