const SavedAccounts = 'savedAccounts';

export function getSavedAccounts() {
    const localStorageValue = window.localStorage.getItem(SavedAccounts);

    if (localStorageValue === null) {
        return [];
    }

    return JSON.parse(localStorageValue);
}

export function saveAccounts(accounts) {
    window.localStorage.setItem(SavedAccounts, JSON.stringify(accounts));
}

export function clearSavedAccounts() {
    window.localStorage.removeItem(SavedAccounts);
}
