import { getSavedAccounts } from 'src/entities/AccountsManager/localStorage';

export function exportAccounts() {
    const accounts = JSON.stringify(getSavedAccounts(), null, 4);

    const link = document.createElement('a');
    link.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(accounts));
    link.setAttribute('download', 'accounts.json');

    if (document.createEvent) {
        const event = document.createEvent('MouseEvents');
        event.initEvent('click', true, true);
        link.dispatchEvent(event);
    } else {
        link.click();
    }
}
