import { synchronizationData as synchronizationDataEntity } from 'src/entities/SynchronizationData';
import { getAccount } from 'src/dataProvider/getAccount';

// На основе данных синхронизации
// Получает аккаунты, наполняет их и сохраняет локально
export async function syncAccounts() {
    const synchronizationData = synchronizationDataEntity.get() || {};

    const accountIds = Object.keys(synchronizationData);

    for (const uid of accountIds) {
        const { environment } = synchronizationData[uid];
        const { isSuccess, account: fetchedAccount } = await getAccount({ uid, environment });

        if (!isSuccess) {
            continue;
        }

        const account = {
            ...fetchedAccount,
            ...synchronizationData[uid],
            inBookmarks: true,
        };

        this.add(account);
    }

    return true;
}
