import { logInfo } from 'src/logger';

class Modal {
    constructor() {
        this.data = {
            message: '',
            type: undefined, // error, например
            isVisible: false,
            closeCallback: () => {},
            retryCallback: () => {},
            closeButtonText: undefined,
            retryButtonText: undefined,
        };
        this.update = () => {};
    }

    setData({ message, callback, closeButtonText, retryButtonText, type }) {
        this.data.type = type;
        this.data.message = message;
        this.data.closeButtonText = closeButtonText;
        this.data.retryButtonText = retryButtonText;
        this.data.retryCallback = callback;
        this.update();
    }

    getData() {
        return this.data;
    }

    show() {
        logInfo({ message: 'modal-show' });
        this.data.isVisible = true;
        this.update();
    }

    hide() {
        this.data.closeCallback();
        this.data.isVisible = false;
        this.update();
    }
}

export const modal = new Modal();
