import { controller, ControllerAction } from 'src/entities/Controller';
import { getSavedUserOAuthToken, saveOAuthToken, removeSavedOAuthToken } from './localStorage';

class OAuthToken {
    constructor() {
        this.saveOAuthToken = saveOAuthToken.bind(this);
        this.getSavedUserOAuthToken = getSavedUserOAuthToken.bind(this);
        this.removeSavedOAuthToken = removeSavedOAuthToken.bind(this);

        this._oAuthToken = this.getSavedUserOAuthToken();
    }

    get() {
        return this._oAuthToken;
    }

    set(value) {
        this._oAuthToken = value;
        this.saveOAuthToken(value);
        controller.dispatch({ action: ControllerAction.SET_NEW_OAUTH_TOKEN });
    }

    clear() {
        this.removeSavedOAuthToken();
        controller.dispatch({ action: ControllerAction.SET_NEW_OAUTH_TOKEN });
        this._oAuthToken = this.getSavedUserOAuthToken();
    }
}

export const oAuthToken = new OAuthToken();
