import { fetchSynchronizationData } from 'src/dataProvider/tracker/fetchSynchronizationData';
import { createNewSynchronizationData } from 'src/dataProvider/tracker/createNewSynchronizationData';
import { parseUserSynchronizationText } from 'src/entities/SynchronizationData/helpers';
import { synchronizationDataId as synchronizationDataIdEntity } from 'src/entities/SynchronizationDataId';

const COMMENT_FALLBACK = {
    isSuccess: false,
    synchronizationData: '',
    synchronizationDataId: undefined,
};

export async function tryFetchSynchronizationData() {
    const {
        isSuccess,
        synchronizationData,
        synchronizationDataId,
        synchronizationDataCanExist,
    } = await fetchSynchronizationData();

    // Если тикет удалось получить, то работаем с ним
    if (isSuccess && synchronizationData) {
        const parsedSynchronizationData = parseUserSynchronizationText(synchronizationData);

        this.set(parsedSynchronizationData);
        synchronizationDataIdEntity.set(synchronizationDataId);
        return { isSuccess, synchronizationDataId, synchronizationData: parsedSynchronizationData };
    }

    // Если комментарий не найден, но в теории может существовать, то ничего не делаем
    if (!isSuccess && synchronizationDataCanExist) {
        return COMMENT_FALLBACK;
    }

    // Иначе пытаемся создать комментарий с данными
    const createTaskCommentResult = await createNewSynchronizationData();

    if (createTaskCommentResult.isSuccess && createTaskCommentResult.synchronizationData) {
        this.set(createTaskCommentResult.synchronizationData);
        synchronizationDataIdEntity.set(createTaskCommentResult.synchronizationDataId);
        return createTaskCommentResult;
    }

    return COMMENT_FALLBACK;
}
