import { SYNCHRONIZATION_DATA_MARKER } from './types';

const SYNCHRONIZATION_DATA_START = `<{${SYNCHRONIZATION_DATA_MARKER}\n`;
const SYNCHRONIZATION_DATA_END = '}>';

export function getUserSynchronizationText(data) {
    const dataString = JSON.stringify(data);

    return `${SYNCHRONIZATION_DATA_START}${dataString}${SYNCHRONIZATION_DATA_END}`;
}

export function parseUserSynchronizationText(text) {
    const startRegExp = new RegExp(`^${SYNCHRONIZATION_DATA_START}`);
    const endRegExp = new RegExp(`${SYNCHRONIZATION_DATA_END}$`);

    const clearedText = text.replace(startRegExp, '').replace(endRegExp, '');

    return JSON.parse(clearedText);
}
