import {
    getSavedSynchronizationData,
    saveSynchronizationData,
    removeSavedSynchronizationData,
} from './localStorage';
import { tryFetchSynchronizationData } from './fetch';
import { patchSynchronizationData } from 'src/dataProvider/tracker/patchSynchronizationData';

class SynchronizationData {
    constructor() {
        this.saveSynchronizationData = saveSynchronizationData.bind(this);
        this.getSavedSynchronizationData = getSavedSynchronizationData.bind(this);
        this.removeSavedSynchronizationData = removeSavedSynchronizationData.bind(this);
        this.tryFetchSynchronizationData = tryFetchSynchronizationData.bind(this);

        this._synchronizationData = this.getSavedSynchronizationData();
    }

    get() {
        return this._synchronizationData;
    }

    set(value) {
        this._synchronizationData = value;
        this.saveSynchronizationData(value);
    }

    async update(value) {
        const updated = {
            ...this._synchronizationData,
            ...value,
        };

        this._synchronizationData = updated;
        this.saveSynchronizationData(updated);
        return await patchSynchronizationData();
    }

    async removeElement(id) {
        delete this._synchronizationData[id];

        this.saveSynchronizationData(this._synchronizationData);
        return await patchSynchronizationData();
    }

    clear() {
        this.removeSavedSynchronizationData();
        this._synchronizationData = this.getSavedSynchronizationData();
    }
}

export const synchronizationData = new SynchronizationData();
