const SynchronizationData = 'synchronizationData';

export function getSavedSynchronizationData() {
    const synchronizationData = window.localStorage.getItem(SynchronizationData);

    if (synchronizationData === null) {
        return null;
    }

    return JSON.parse(synchronizationData);
}

export function saveSynchronizationData(value) {
    window.localStorage.setItem(SynchronizationData, JSON.stringify(value));
}

export function removeSavedSynchronizationData() {
    window.localStorage.removeItem(SynchronizationData);
}
