import {
    getSavedSynchronizationDataId,
    saveSynchronizationDataId,
    removeSavedSynchronizationDataId,
} from './localStorage';

class SynchronizationDataId {
    constructor() {
        this.saveSynchronizationDataId = saveSynchronizationDataId.bind(this);
        this.getSavedSynchronizationDataId = getSavedSynchronizationDataId.bind(this);
        this.removeSavedSynchronizationDataId = removeSavedSynchronizationDataId.bind(this);

        this._synchronizationDataId = this.getSavedSynchronizationDataId();
    }

    get() {
        return this._synchronizationDataId;
    }

    set(value) {
        this._synchronizationDataId = value;
        this.saveSynchronizationDataId(value);
    }

    clear() {
        this.removeSavedSynchronizationDataId();
        this._synchronizationDataId = this.getSavedSynchronizationDataId();
    }
}

export const synchronizationDataId = new SynchronizationDataId();
