import { findTaskByUserConsumer } from 'src/dataProvider/tracker/findTask';
import { createTaskForUserConsumer } from 'src/dataProvider/tracker/createTask';

const FALLBACK = { isSuccess: false, taskKey: '' };

export async function tryFetchTrackerTask() {
    const { taskCanExist, isSuccess, taskKey } = await findTaskByUserConsumer();

    // Если тикет удалось получить, то работаем с ним
    if (isSuccess && taskKey) {
        this.set(taskKey);
        return { isSuccess, taskKey };
    }

    // Если тикет не найден, но в теории может существовать, то ничего не делаем
    if (!isSuccess && taskCanExist) {
        return FALLBACK;
    }

    // Иначе пытаемся создать тикет для пользователя
    const createTaskResult = await createTaskForUserConsumer();

    if (createTaskResult.isSuccess && createTaskResult.taskKey) {
        this.set(createTaskResult.taskKey);
        return createTaskResult;
    }

    return FALLBACK;
}
