import { getSavedTrackerTask, saveTrackerTask, removeSavedTrackerTask } from './localStorage';
import { tryFetchTrackerTask } from './fetch';

class TrackerTask {
    constructor() {
        this.saveTrackerTask = saveTrackerTask.bind(this);
        this.getSavedTrackerTask = getSavedTrackerTask.bind(this);
        this.removeSavedTrackerTask = removeSavedTrackerTask.bind(this);
        this.tryFetchTrackerTask = tryFetchTrackerTask.bind(this);

        this._trackerTask = this.getSavedTrackerTask();
    }

    get() {
        return this._trackerTask;
    }

    set(value) {
        this._trackerTask = value;
        this.saveTrackerTask(value);
    }

    clear() {
        this.removeSavedTrackerTask();
        this._trackerTask = this.getSavedTrackerTask();
    }
}

export const trackerTask = new TrackerTask();
