import {
    createConsumer,
    CreateConsumerError,
    CreateConsumerStatus,
} from 'src/dataProvider/createConsumer';

export async function tryCreateConsumer() {
    const result = await createConsumer();
    const { userConsumer, status, error } = result;

    if (status !== CreateConsumerStatus.OK && error !== CreateConsumerError.ALREADY_EXIST) {
        return;
    }

    this.saveUserConsumer(userConsumer);
    this._userConsumer = userConsumer;

    return userConsumer;
}
