import { getSavedUserConsumer, saveUserConsumer, removeSavedUserConsumer } from './localStorage';
import { tryCreateConsumer } from './fetch';

class UserConsumer {
    constructor() {
        this.getSavedUserConsumer = getSavedUserConsumer.bind(this);
        this.saveUserConsumer = saveUserConsumer.bind(this);
        this.removeSavedUserConsumer = removeSavedUserConsumer.bind(this);
        this.tryCreateConsumer = tryCreateConsumer.bind(this);

        this._userConsumer = this.getSavedUserConsumer();
    }

    get() {
        return this._userConsumer;
    }

    set(value) {
        this._userConsumer = value;
        this.saveUserConsumer(value);
    }

    clear() {
        this.removeSavedUserConsumer();
        this._userConsumer = this.getSavedUserConsumer();
    }
}

export const userConsumer = new UserConsumer();
