import {
    getSavedYandexTeamLogin,
    saveYandexTeamLogin,
    removeSavedYandexTeamLogin,
} from './localStorage';
import { tryFetchYandexTeamLogin } from './fetch';

class YandexTeamLogin {
    constructor() {
        this.getSavedYandexTeamLogin = getSavedYandexTeamLogin.bind(this);
        this.saveYandexTeamLogin = saveYandexTeamLogin.bind(this);
        this.removeSavedYandexTeamLogin = removeSavedYandexTeamLogin.bind(this);
        this.tryFetchYandexTeamLogin = tryFetchYandexTeamLogin.bind(this);

        this._yandexTeamLogin = this.getSavedYandexTeamLogin();
    }

    get() {
        return this._yandexTeamLogin;
    }

    set(value) {
        this._yandexTeamLogin = value;
        this.saveYandexTeamLogin(value);
    }

    clear() {
        this.removeSavedYandexTeamLogin();
        this._yandexTeamLogin = this.getSavedYandexTeamLogin();
    }
}

export const yandexTeamLogin = new YandexTeamLogin();
