import { oAuthToken } from 'src/entities/OAuthToken';
import { yandexTeamLogin } from 'src/entities/YandexTeamLogin';
import { userConsumer } from 'src/entities/UserConsumer';
import { sendCommonMetrics } from 'src/utils/yandexMetrika';

import { logError, logInfo, updateAdditional } from 'src/logger';

function executionTimeout(ms) {
    console.log(`executionTimeout >>> ${ms}ms`);
    logError({ message: `execution-timeout:${ms}ms` });

    return new Promise(resolve => {
        setTimeout(() => {
            console.warn(warningText);
            resolve();
        }, ms);
    });
}

export async function init(timeout) {
    logInfo({ message: 'init:start' });

    if (timeout) {
        await executionTimeout(timeout);
    }

    if (!oAuthToken.get()) {
        return;
    }

    /** yandexTeamLogin */

    if (!yandexTeamLogin.get()) {
        await yandexTeamLogin.tryFetchYandexTeamLogin();
        logInfo({ message: 'init:no-yandex-team-login:try-fetch' });
    }

    if (!yandexTeamLogin.get()) {
        logError({ message: 'init:can-not-get-yandex-team-login' });
        return;
    }

    updateAdditional({ user: yandexTeamLogin.get() });
    logError({ message: 'init:yandex-team-log' });
    sendCommonMetrics({ appInit_user: yandexTeamLogin.get() });

    /** userConsumer */
    if (!userConsumer.get()) {
        await userConsumer.tryCreateConsumer();
        logInfo({ message: 'init:no-tus-user-consumer:try-fetch' });
    }

    updateAdditional({ tusConsumer: userConsumer.get() });
    logInfo({ message: 'init:tus-user-consumer' });
    sendCommonMetrics({ appInit_userConsumer: userConsumer.get() });
}
