/** Используется light версия error-counter */
// https://error.yandex-team.ru/projects/yawe-extension/projectDashboard
import Logger from '@yandex-int/error-counter/dist/logger';
import { sessionId } from 'src/types/sessionId';

const logger = new Logger();

logger.initErrors({ project: 'yawe-extension', uncaughtException: false });
logger.updateAdditional({ sessionId });

export function logError({ message }) {
    updateAdditional({ timestamp: +new Date() });
    logger.logError({ level: 'error', message });
}

export function logInfo({ message }) {
    updateAdditional({ timestamp: +new Date() });
    logger.logError({ level: 'info', message });
}

export function updateAdditional(obj) {
    logger.updateAdditional(obj);
}
