function withZero(value) {
    return value < 10 ? `0${value}` : `${value}`;
}

export function getCurrentDate() {
    return +new Date();
}

export function formatDate(timestamp) {
    const date = new Date(timestamp);

    const day = withZero(date.getDate());
    const month = withZero(date.getMonth() + 1);
    const year = date.getFullYear();

    const hours = withZero(date.getHours());
    const minutes = withZero(date.getMinutes());

    return `${day}.${month}.${year} ${hours}:${minutes}`;
}
