import { URL } from 'src/constants/urls';
import { Environment } from 'src/constants/environment';

export function getPassportDomain(environment) {
    if (environment === Environment.TESTING) {
        return URL.PASSPORT_TEST;
    }

    return URL.PASSPORT;
}

export function getPassportURL(account) {
    if (!account) return undefined;

    const { login, environment } = account;

    const passportDomain = getPassportDomain(environment);

    return `${passportDomain}?login=${login}`;
}
