import config from 'src/config';

const actualVersion = 'actualVersion';

export function getActualVersion() {
    return window.localStorage.getItem(actualVersion);
}

export function saveActualVersion(value) {
    window.localStorage.setItem(actualVersion, value);
}

export function getNewestVersionAvailable(actualVersion) {
    const currentV = parseInt(config.version);

    let newestV = parseInt(actualVersion);

    if (!actualVersion) {
        newestV = parseInt(getActualVersion());
    }

    return newestV > currentV;
}
