import { sessionId } from 'src/types/sessionId';
import { useEffect } from 'react';
import { logInfo, updateAdditional } from 'src/logger';

const counterId = '62824321';
const goalId = {
    COMMON_METRICS: 'common-metrics',
};

function getYM() {
    const { ym } = window;

    return [Boolean(ym), ym];
}

export function sendCommonMetrics(params) {
    const [canUse, ym] = getYM();

    if (!canUse) {
        return;
    }

    ym(counterId, 'reachGoal', goalId.COMMON_METRICS, {
        ...params,
        sessionId,
        timestamp: +new Date(),
    });
}

export function usePageAnalytics(pageName) {
    useEffect(() => {
        updateAdditional({ page: pageName });
        logInfo({ message: `show-page:${pageName}` });
        sendCommonMetrics({ pageRender: pageName });
    }, [pageName]);
}
