const path = require('path');
const { DefinePlugin } = require('webpack');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const manifest = require('./extension/manifest.json');

const { version } = manifest;

const OUTPUT_FILE_NAME = 'application';

module.exports = (env, argv) => ({
    entry: './src/index.jsx',
    resolve: {
        extensions: ['.js', '.jsx'],
        alias: {
            src: path.resolve(__dirname, 'src/'),
        },
    },
    devtool: 'inline-source-map',
    output: {
        filename: `${OUTPUT_FILE_NAME}.js`,
        path: path.resolve(__dirname, 'extension'),
    },
    module: {
        rules: [
            {
                test: /\.js|.jsx$/,
                exclude: /node_modules/,
                use: {
                    loader: 'babel-loader',
                },
            },
            {
                test: /\.pcss/,
                use: [
                    'style-loader',
                    {
                        loader: 'css-loader',
                        options: {
                            sourceMap: true,
                            importLoaders: 1,
                            modules: {
                                localIdentName: '[name]__[local]___[hash:base64:5]',
                                exportLocalsConvention: 'camelCase',
                            },
                        },
                    },
                    { loader: 'postcss-loader' },
                ],
            },
            {
                test: /\.(svg|png|jpg|gif)$/i,
                use: [
                    {
                        loader: 'file-loader',
                    },
                ],
            },
        ],
    },
    plugins: [
        new HtmlWebpackPlugin({
            template: './src/index.html',
            filename: 'popup.html',
            data: {
                script: argv.mode === 'production' ? 'popup' : OUTPUT_FILE_NAME,
            },
            inject: false,
        }),
        new DefinePlugin({
            'process.env.VERSION': JSON.stringify(version),
        }),
    ],
});
